<?php

namespace App\Http\Controllers;

use App\Affilate;
use App\Config;
use App\Mail\SendInvoiceMailable;
use App\ManualPaymentMethod;
use App\Menu;
use App\Package;
use App\PackageFeature;
use App\PaypalSubscription;
use App\PricingText;
use App\Season;
use Barryvdh\DomPDF\Facade\Pdf;
use App\User;
use App\Country;
use App\State;
use App\City;
use App\Movie;
use App\PpvPurchase;
use App\TvSeries;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Laravel\Cashier\Cashier;
use Stripe\Subscription;
use Stripe\Coupon;
use Stripe\Invoice;
use Stripe\Stripe;
use Stripe\Customer;
use App\Gst;


class UserAccountController extends Controller
{


public function index()
    {
        // Set your secret key: remember to change this to your live secret key in production
        Stripe::setApiKey(env('STRIPE_SECRET'));
        $auth = Auth::user();
        if ($auth->stripe_id != null) {

            $customer = Cashier::findBillable($auth->stripe_id);
        }
        $ppv_purchases = DB::table('ppv_purchases')
    ->leftJoin('movies', 'ppv_purchases.movie_id', '=', 'movies.id')
    ->leftJoin('seasons', 'ppv_purchases.tv_series_id', '=', 'seasons.id')
    ->leftJoin('tv_series', 'seasons.tv_series_id', '=', 'tv_series.id')
    ->select(
        'ppv_purchases.*',
        'movies.title as movie_title',
        'tv_series.title as tv_series_title'
    )
    ->where('ppv_purchases.user_id', $auth->id)
    ->get();

        $paypal = $auth->paypal_subscriptions->sortBy('created_at');
        $plans = Package::all();
        $country = Country::all();
        $state= State::all();
        $city = City::all();
        $current_subscription = null;
        $method = null;
        $current_date = Carbon::now()->toDateString();
        if (isset($customer)) {

            $alldata = $auth->subscriptions;
            $data = $alldata->last();
        }
        if (isset($paypal) && $paypal != null && count($paypal) > 0) {
            $last = $paypal->last();
        }
         $stripedate = isset($data) ? $data->created_at : null;
        $paydate = isset($last) ? $last->created_at : null;
        
        if ($stripedate > $paydate) {
            if ($auth->subscribed($data->name)) {
                if (date($current_date) <= date($data->subscription_to)) {
                    $current_subscription = $data;
                    $method = 'stripe';
                }
            }
        } elseif ($stripedate < $paydate) {
            if (date($current_date) <= date($last->subscription_to)) {
                $current_subscription = $last;
                $method = 'paypal';
            }
        }

        $paypal_subscriptions = PaypalSubscription::where('user_id', $auth->id)->get();
        $customer = Cashier::findBillable($auth->stripe_id);

        if ($customer) {
            $invoices = $customer->subscriptions;
        } else {
            $invoices = null;
        }

        $currency_symbol = Config::first()->currency_symbol;
        

        //affiliate
        $af_settings = Affilate::first();

        

        if (auth()->user()->refer_code == '') {

            auth()->user()->update([
                'refer_code' => User::createReferCode(),
            ]);

        }

        $aff_history = auth()->user()->getReferals()->with(['user' => function ($q) {
            return $q->select('id', 'email');
        }])->wherehas('user')->paginate(10);

        $earning = auth()->user()->getReferals()->wherehas('user')->sum('amount');

       

        return view('user.index', compact('auth', 'plans', 'country', 'state', 'city', 'current_subscription', 'method', 'invoices', 'paypal_subscriptions', 'currency_symbol','earning','aff_history','af_settings','ppv_purchases'));
    }



    public function purchase_plan()
    {
        $plans = Package::all();
        $pricingTexts = PricingText::all();
        $package_feature = PackageFeature::get();
        

        Stripe::setApiKey(env('STRIPE_SECRET'));
        $auth = Auth::user();
        if ($auth->stripe_id != null) {
            $customer = Cashier::findBillable($auth->stripe_id);
        }
        $paypal = $auth->paypal_subscriptions->sortBy('created_at');
        $plans = Package::all();
        $current_subscription = null;
        $method = null;
        $current_date = Carbon::now()->toDateString();
        if (isset($customer)) {

            $alldata = $auth->subscriptions;
            $data = $alldata->last();
        }
        if (isset($paypal) && $paypal != null && count($paypal) > 0) {
            $last = $paypal->last();
        }
        $stripedate = isset($data) ? $data->created_at : null;
        $paydate = isset($last) ? $last->created_at : null;
        if ($stripedate > $paydate) {
            if ($auth->subscribed($data->name)) {
                if (date($current_date) <= date($data->subscription_to)) {
                    $current_subscription = $data;
                }
            }
        } elseif ($stripedate < $paydate) {
            if (date($current_date) <= date($last->subscription_to)) {
                $current_subscription = $last;
            }
        }

        Session::forget('coupon_applied');

        return view('user.purchaseplan', compact('plans', 'pricingTexts', 'package_feature', 'current_subscription'));
    }

    public function get_payment(Request $request, $id)
{
    $config = Config::first();
    if (!isset($config) || $config == null) {
        return back()->with('deleted', __('Default Settings not found !'));
    }

    $type = $request->type ?? 'subscription';

    // Initialize variables
    $movie = "";
    $plan = "";
    $series = ""; // This will now hold a season object
    $price = 0;
    $name = "";

    if ($type == 'subscription') {
        $plan = Package::findOrFail($id);
        $price = $plan->amount;
        $name = $plan->name;
    } elseif ($type == 'rental') {
        $movie = Movie::findOrFail($id);
        $price = $movie->offer_price ?? $movie->price;
        $name = $movie->title;
    } elseif ($type == 'rental_series') {
        // Changed from TvSeries to Season
        $series = Season::findOrFail($id);
        $price = $series->offer_price ?? $series->price;
        $name = 'Season ' . $series->season_no; // Optional: customize this
    }

    // Currency conversion
    $base_currency = $config->currency_code;
    $converted_amount = (Session::has('current_currency'))
        ? round(currency($price, $from = $base_currency, $to = ucfirst(Session::get('current_currency')), $format = false), 2)
        : round($price, 2);

    $converted_symbol = DB::table('currencies')
        ->where('code', ucfirst(Session::get('current_currency')))
        ->value('symbol') ?? DB::table('currencies')->where('active', 1)->value('symbol');

    $converted_code = DB::table('currencies')
        ->where('code', ucfirst(Session::get('current_currency')))
        ->value('code') ?? DB::table('currencies')->where('active', 1)->value('code');

    // Payment gateways
    $bankdetails = $config->bankdetails;
    $razorpay_payment = $config->razorpay_payment;
    $instamojo_payment = $config->instamojo_payment;
    $stripe_payment = $config->stripe_payment;
    $mollie_payment = $config->mollie_payment;
    $coin_payment = $config->coinpay;
    $cashfree_payment = $config->cashfree_payment;
    $omise_payment = $config->omise_payment;
    $flutterrave_payment = $config->flutterrave_payment;
    $payhere_payment = $config->payhere_payment;
    $worldpay_payment = $config->worldpay_payment;
    $squarepay_payment = $config->squarepay_payment;

    $account_name = $config->account_name;
    $account_no = $config->account_no;
    $ifsc_code = $config->ifsc_code;
    $bank = $config->bank_name;

    $manualpaymentmethod = ManualPaymentMethod::where('status', 1)->get();

    $intent = '';
    if (env('STRIPE_SECRET') != null && env('STRIPE_KEY') != null && $stripe_payment == 1) {
        $paymentMethods = $request->user()->paymentMethods();
        $intent = $request->user()->createSetupIntent();
    }

    $currency = DB::table('currencies')->where('code', $converted_code)->first();
    if (isset($currency) && $currency != null) {
        $currency_payments = (array) json_decode($currency->payment_method, true);
    } else {
        $currency_payments = [];
        $currency_code = $config->currency_code;
        $currency = DB::table('currencies')->where('code', $currency_code)->first();
        if (isset($currency) && $currency != null) {
            $currency_payments = (array) json_decode($currency->payment_method, true);
        }
    }

    return view('subscribe', compact(
        'type',
        'price',
        'name',
        'stripe_payment',
        'currency_payments',
        'bankdetails',
        'account_no',
        'account_name',
        'ifsc_code',
        'bank',
        'razorpay_payment',
        'intent',
        'instamojo_payment',
        'mollie_payment',
        'cashfree_payment',
        'omise_payment',
        'flutterrave_payment',
        'manualpaymentmethod',
        'coin_payment',
        'payhere_payment',
        'worldpay_payment',
        'squarepay_payment',
        'movie',
        'plan',
        'series', // now holds Season object
        'converted_amount',
        'converted_symbol',
        'converted_code'
    ));
}
    

    public function subscribe(Request $request)
    {
        $menus = Menu::all();
        ini_set('max_execution_time', 80);
        // Set your secret key: remember to change this to your live secret key in production
        \Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));
        $auth = Auth::user();
        $token = $request->stripeToken;
        $coupon_valid = false;
        $coupon = $request->coupon;
        $paymentMethod = $request->paymentMethod;
        $type = $request->type;
        $currencyi = DB::table('currencies')->where('active', 1)->first();
    
    
        if ($type == 'subscription') {
            $plan = Package::find($request->plan);
            if (!$plan) {
                return back()->with('delete', __('Plan not found !'));
            }
    
            if ($coupon != null) {
                try {
                    $stripe_coupon = Coupon::retrieve($coupon);
                    $coupon_valid = true;
                    if ($stripe_coupon->valid == false) {
                        $coupon_valid = false;
                        return back()->with('deleted', __('Coupon has been expired'));
                    }
                } catch (\Exception $e) {
                    $error = $e->getMessage();
                    $coupon_valid = false;
                }
            }
    
            if ($coupon_valid == false && $request->coupon) {
                return back()->with('deleted', $error);
            }
    
            $plan_id = $plan->plan_id;
            $plan_name = $plan->name;
    
            if ($coupon_valid == true && $request->coupon) {
                try {
                    $purchased = $auth->newSubscription($plan_name, $plan_id)
                        ->withCoupon($request->coupon)
                        ->create($paymentMethod, [
                            'email' => $auth->email,
                        ]);
    
                    $last_plan = $auth->subscriptions->last();
                    $current_date = Carbon::now();
                    $end_date = null;
    
                    if ($plan->interval == 'month') {
                        $end_date = Carbon::now()->addMonths($plan->interval_count);
                    } else if ($plan->interval == 'year') {
                        $end_date = Carbon::now()->addYears($plan->interval_count);
                    } else if ($plan->interval == 'week') {
                        $end_date = Carbon::now()->addWeeks($plan->interval_count);
                    } else if ($plan->interval == 'day') {
                        $end_date = Carbon::now()->addDays($plan->interval_count);
                    }
    
                    DB::table('subscriptions')->where('id', '=', $last_plan->id)->update([
                        'subscription_from' => $current_date,
                        'subscription_to' => $end_date,
                        'amount' => $plan->amount,
                    ]);
    
                    if (isset($purchased) || $purchased != null) {
                        Mail::to($auth->email)->send(new SendInvoiceMailable());
                        if (isset($menus) && count($menus) > 0) {
                            return redirect()->route('home', $menus[0]->slug)->with('added', __('Your are now a subscriber !'));
                        }
                        return redirect('/')->with('success', __('Your are now a subscriber !'));
                    } else {
                        return back()->with('deleted', __('Subscription failed ! Please check your debit or credit card.'));
                    }
                } catch (\Exception $e) {
                    return back()->with('deleted', $e->getMessage());
                }
            } else {
                try {
                    $purchased = $auth->newSubscription($plan_name, $plan_id)
                        ->create($paymentMethod, [
                            'email' => $auth->email,
                        ]);
    
                    $last_plan = $auth->subscriptions->last();
                    $current_date = Carbon::now();
                    $end_date = null;
    
                    if ($plan->interval == 'month') {
                        $end_date = Carbon::now()->addMonths($plan->interval_count);
                    } else if ($plan->interval == 'year') {
                        $end_date = Carbon::now()->addYears($plan->interval_count);
                    } else if ($plan->interval == 'week') {
                        $end_date = Carbon::now()->addWeeks($plan->interval_count);
                    } else if ($plan->interval == 'day') {
                        $end_date = Carbon::now()->addDays($plan->interval_count);
                    }
                    DB::table('subscriptions')->where('id', '=', $last_plan->id)->update([
                        'subscription_from' => $current_date,
                        'subscription_to' => $end_date,
                        'amount' => $plan->amount,
                    ]);
    
                    if (isset($purchased) || $purchased != null) {
                        Mail::to($auth->email)->send(new SendInvoiceMailable());
                        return redirect('/')->with('success', __('Your are now a subscriber !'));
                    } else {
                        return back()->with('deleted', __('Subscription failed ! Please check your debit or credit card.'));
                    }
                } catch (\Exception $e) {
                    return back()->with('deleted', $e->getMessage());
                }
            }
        } 
        // Handle PPV payment
        elseif ($type == 'ppv') {
            try {
                Log::info('Starting PPV payment process', [
                    'user_id' => $auth->id,
                    'payment_method' => $paymentMethod,
                ]);
    
                $movie = Movie::find($request->movie_id);
                if (!$movie) {
                    Log::error('Movie not found', ['movie_id' => $request->movie_id]);
                    return back()->with('delete', __('Movie not found !'));
                }
    
                Log::info('Found movie', [
                    'movie_id' => $movie->id,
                    'price' => $movie->price,
                    'title' => $movie->title
                ]);
    
                // Create or get Stripe customer
                $stripeCustomer = $auth->createOrGetStripeCustomer();
                
                Log::info('Stripe customer', ['customer_id' => $stripeCustomer->id]);
    
                // Create Payment Intent
                $intent = \Stripe\PaymentIntent::create([
                    'amount' => $movie->offer_price ? $movie->offer_price * 100 : $movie->price * 100,
                    'currency' => $currencyi->code,
                    'customer' => $stripeCustomer->id,
                    'payment_method' => $paymentMethod,
                    'confirmation_method' => 'manual',
                    'confirm' => true,
                    'return_url' => route('home.view'), // Your return URL
                    'description' => "PPV Purchase for Movie: {$movie->title}",
                    'metadata' => [
                        'movie_id' => $movie->id,
                        'user_id' => $auth->id,
                        'movie_title' => $movie->title
                    ]
                ]);            
                
    
                Log::info('Payment Intent created', [
                    'intent_id' => $intent->id,
                    'status' => $intent->status
                ]);
    
                if ($intent->status === 'requires_action') {
                    Log::info('Payment requires action', [
                        'action_type' => $intent->next_action->type ?? null,
                        'redirect_url' => $intent->next_action->redirect_to_url->url ?? null
                    ]);
    
                    return response()->json([
                        'requires_action' => true,
                        'payment_intent_client_secret' => $intent->client_secret,
                        'redirect_url' => $intent->next_action->redirect_to_url->url
                    ]);
                }
    
                if ($intent->status === 'succeeded') {
                    // Create PPV purchase record
                    $purchase = PpvPurchase::create([
                        'user_id' => $auth->id,
                        'movie_id' => $movie->id,
                        'payment_id' => $intent->id,
                        'price' => $movie->price,
                        'payment_type' => 'Stripe',
                        'offer_price' => $movie->offer_price ?? $movie->price,
                        'hours' => $movie->hours,
                        'type' => 'movie',
                        'expires_at' => now()->addHours($movie->hours),
                        'status' => 1,
                    ]);
    
                    Log::info('PPV purchase successful', [
                        'purchase_id' => $purchase->id,
                        'payment_intent_id' => $intent->id
                    ]);
    
                    if (getSubscription()->getData()->subscribed == true) {
                        // Subscription is active
                        $route = 'movie/detail/';
                    } else {
                        // Subscription is not active
                        $route = 'movie/guest/detail/';
                    }               
                    return redirect()->to($route . $movie->slug)->with('success', __('Movie purchase successful!'));
    
                }
    
                Log::error('Payment failed', [
                    'intent_status' => $intent->status,
                    'last_payment_error' => $intent->last_payment_error ?? null
                ]);
    
                return back()->with('deleted', __('Payment failed! Please try again.'));
    
            } catch (\Exception $e) {
                Log::error('PPV Payment Error', [
                    'error' => $e->getMessage(),
                    'trace' => $e->getTraceAsString()
                ]);
                return back()->with('deleted', __('Payment processing failed. Please try again.'));
            }
        } 
    
    
        elseif ($type == 'ppv_series') {
            try {
                Log::info('Starting PPV payment process', [
                    'user_id' => $auth->id,
                    'payment_method' => $paymentMethod,
                ]);
    
                $series = TvSeries::find($request->series_id);
                if (!$series) {
                    Log::error('Series not found', ['series_id' => $request->series_id]);
                    return back()->with('delete', __('Series not found !'));
                }
    
                Log::info('Found series', [
                    'series_id' => $series->id,
                    'price' => $series->price,
                    'title' => $series->title
                ]);
    
                // Create or get Stripe customer
                $stripeCustomer = $auth->createOrGetStripeCustomer();
                
                Log::info('Stripe customer', ['customer_id' => $stripeCustomer->id]);
    
                // Create Payment Intent
                $intent = \Stripe\PaymentIntent::create([
                    'amount' => $series->offer_price ? $series->offer_price * 100 : $series->price * 100,
                    'currency' => $currencyi->code,
                    'customer' => $stripeCustomer->id,
                    'payment_method' => $paymentMethod,
                    'confirmation_method' => 'manual',
                    'confirm' => true,
                    'return_url' => route('home.view'), // Your return URL
                    'description' => "PPV Purchase for Series: {$series->title}",
                    'metadata' => [
                        'movie_id' => $series->id,
                        'user_id' => $auth->id,
                        'movie_title' => $series->title
                    ]
                ]);            
                
    
                Log::info('Payment Intent created', [
                    'intent_id' => $intent->id,
                    'status' => $intent->status
                ]);
    
                if ($intent->status === 'requires_action') {
                    Log::info('Payment requires action', [
                        'action_type' => $intent->next_action->type ?? null,
                        'redirect_url' => $intent->next_action->redirect_to_url->url ?? null
                    ]);
    
                    return response()->json([
                        'requires_action' => true,
                        'payment_intent_client_secret' => $intent->client_secret,
                        'redirect_url' => $intent->next_action->redirect_to_url->url
                    ]);
                }
    
                if ($intent->status === 'succeeded') {
                    // Create PPV purchase record
                    $purchase = PpvPurchase::create([
                        'user_id' => $auth->id,
                        'tv_series_id' => $series->id,
                        'payment_id' => $intent->id,
                        'price' => $series->price,
                        'payment_type' => 'Stripe',
                        'type' => 'series',
                        'offer_price' => $series->offer_price ?? $series->price,
                        'hours' => $series->hours,
                        'expires_at' => now()->addHours($series->hours),
                        'status' => 1,
                    ]);
    
                    Log::info('PPV purchase successful', [
                        'purchase_id' => $purchase->id,
                        'payment_intent_id' => $intent->id
                    ]);
    
                    if (getSubscription()->getData()->subscribed == true) {
                        // Subscription is active
                        $route = 'show/detail/';
                    } else {
                        // Subscription is not active
                        $route = 'show/guest/detail/';
                    }
                    return redirect()->to($route . $series->seasons_first->season_slug)->with('success', __('Series rental successful!'));
                }
    
                Log::error('Payment failed', [
                    'intent_status' => $intent->status,
                    'last_payment_error' => $intent->last_payment_error ?? null
                ]);
    
                return back()->with('deleted', __('Payment failed! Please try again.'));
    
            } catch (\Exception $e) {
                Log::error('PPV Payment Error', [
                    'error' => $e->getMessage(),
                    'trace' => $e->getTraceAsString()
                ]);
                return back()->with('deleted', __('Payment processing failed. Please try again.'));
            }
        } 
        
        
        
        
        else {
            return back()->with('deleted', __('Invalid payment type.'));
        }
    }

    public function edit_profile()
    {
        return view('user.edit_profile');
    }

    public function update_mobile(Request $request)
    {
        if (config('app.demolock') == 1) {
            return back()->with('deleted', __('This action is disabled in the demo !'));
        }
        $id = Auth::user()->id;
        $user = User::find($id);
        $input = $request->all();

        $dateOfBirth = $request->dob;
       if (isset($request->dob)) {
            $user->dob = $request->dob;
            $today = date("Y-m-d");
            $diff = date_diff(date_create($dateOfBirth), date_create($today));
            $age = $diff->format('%y');
            $user->age = $age;

        }
        $user->age = $request->age;

        $user->mobile = $request->mobile;

        $user->save();
        return back()->with('success', __('Your Age Has Been Updated'));
    }

    public function update_profile(Request $request)
    {
        if (config('app.demolock') == 1) {
            return back()->with('deleted', __('This action is disabled in the demo !'));
        }
        $auth = Auth::user();

        if ($request->image != null) {

            if ($file = $request->file('image')) {
                $name = 'user_' . time() . $file->getClientOriginalName();
                if ($auth->image != null) {
                    $content = @file_get_contents(public_path() . '/images/users/' . $auth->image);
                    if ($content) {
                        unlink(public_path() . '/images/users/' . $auth->image);
                    }
                }
                $file->move('images/users/', $name);
                $input['image'] = $name;
                $auth->update([
                    'image' => $input['image'],
                ]);
                return back()->with('success', __('Profile image has been updated'));

            }
        }

        if (Hash::check($request->current_password, $auth->password)) {
            if ($request->new_email !== null) {
                $request->validate([
                    'new_email' => 'required|email',
                    'current_password' => 'required',
                ]);
                $auth->update([
                    'email' => $request->new_email,
                ]);
                return back()->with('success', __('Email has been updated'));
            }

            if ($request->new_name !== null) {
                $request->validate([
                    'new_name' => 'required|',
                    'current_password' => 'required',
                ]);
                $auth->update([
                    'name' => $request->new_name,
                ]);
                return back()->with('success', __('Name has been updated'));
            }

            if ($request->new_password !== null) {
                $request->validate([
                    'new_password' => 'required|min:6',
                    'current_password' => 'required',
                ]);
                $auth->update([
                    'password' => bcrypt($request->new_password),
                ]);
                return back()->with('success', __('Password has been updated'));
            }

        }

    }


    public function update_otherprofilesetting(Request $request){
        $auth = Auth::user();
        $auth->update([
            'facebook_url' => isset($request->facebook_url)  ?  $request->facebook_url : NULL,
            'youtube_url' =>  isset($request->youtube_url)  ?  $request->youtube_url : NULL,
            'twitter_url' =>  isset($request->twitter_url)  ?  $request->twitter_url : NULL
        ]);
        return back()->with('success', __('User other settings has been updated'));
        

    }

    public function history()
    {
        $auth = Auth::user();
        // Set your secret key: remember to change this to your live secret key in production
        Stripe::setApiKey(env('STRIPE_SECRET'));

        $paypal_subscriptions = PaypalSubscription::where('user_id', $auth->id)->get();
        $customer = Cashier::findBillable($auth->stripe_id);
        $invoices = $auth->subscriptions;
        return view('user.history', compact('invoices', 'paypal_subscriptions'));
    }
    public function cancelSub($plan_id)
    {

        try {
            $subs = auth()->user()->subscriptions()->orderBY('id', 'DESC')->first();

            \Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));

            \Stripe\Subscription::update(
                $subs->stripe_id,
                [
                    'pause_collection' => [
                        'behavior' => 'mark_uncollectible',
                    ],
                ]
            );

        } catch (\Exception $e) {

        }

        return back()->with('deleted', __('Subscription has been cancelled'));
    }

    public function resumeSub($plan_id)
    {

        $subs = auth()->user()->subscriptions()->orderBY('id', 'DESC')->first();

        \Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));

        \Stripe\Subscription::update(
            $subs->stripe_id,
            [
                'pause_collection' => '',
            ]
        );

        return back()->with('success', __('Subscription has been resumed'));
    }

    public function PaypalCancel()
    {
        $auth = Auth::user();
        $auth->paypal_subscriptions->last()->status = 0;
        $auth->paypal_subscriptions->last()->save();
        return back()->with('deleted', __('Subscription has been cancelled'));
    }

    public function PaypalResume()
    {
        $auth = Auth::user();
        $last = $auth->paypal_subscriptions->last();
        $last->status = 1;
        $last->save();
        return back()->with('success', __('Subscription has been resumed'));
    }
    public function watchhistory()
    {
        return view('search');
    }

    public function invoice($id)
    {
        $invoice = PaypalSubscription::find($id);
        $gst = Gst::first();
        if (selected_lang()->rtl == 0) {
            return view('user.show_invoice', compact('invoice','gst'));
        } else {
            return view('user.show_invoice_rtl', compact('invoice','gst'));
        }

    }
    public function invoice2($id)
{
    $invoice = PpvPurchase::find($id);
    $gst = Gst::first();

    $config = Config::first();
    $base_currency = $config ? $config->currency_code : 'USD'; // fallback if no config
    $current_currency = Session::get('current_currency', $base_currency);

    // Assuming $invoice has a 'price' or 'amount' field to convert
    $price = $invoice->amount ?? 0; // adjust if your price field name is different

    $converted_amount = round(currency($price, $base_currency, ucfirst($current_currency), false), 2);

    $converted_symbol = DB::table('currencies')
        ->where('code', ucfirst($current_currency))
        ->value('symbol')
        ?? DB::table('currencies')->where('code', $base_currency)->value('symbol');

    if (selected_lang()->rtl == 0) {
        return view('user.show_invoice1', compact('invoice', 'gst', 'converted_amount', 'converted_symbol', 'current_currency'));
    } else {
        return view('user.show_invoice_rtl1', compact('invoice', 'gst', 'converted_amount', 'converted_symbol', 'current_currency'));
    }
}


    public function pdfdownload($id)
    {
        
        $invoice = PaypalSubscription::find($id);
        
        if (!$invoice) {
            abort(404, 'Invoice not found');
        }
    
        $currency_code = env('CURRENCY_CODE');
        $invoice_add = env('INVOICE_ADDRESS');
        $w_email = env('W_EMAIL');
        $gst = Gst::first();
        $data = [
            'invoice' => $invoice,
            'currency_code' => $currency_code,
            'invoice_add' => $invoice_add,
            'w_email' => $w_email,
            'gst' => $gst,
        ];
    
        $pdf = Pdf::loadView('user.download', $data);
    
        $pdf->setPaper('A4', 'landscape');
        $pdf->setOptions([
            'isHtml5ParserEnabled' => true,
            'isRemoteEnabled' => true,
        ]);
    
        return $pdf->download('invoice' . $invoice->id . '.pdf');
    }
          public function pdfdownload2($id)
        {
            $invoice = PpvPurchase::find($id);
            
            if (!$invoice) {
                abort(404, 'Invoice not found');
            }
        
            $currency_code = env('CURRENCY_CODE');
            $invoice_add = env('INVOICE_ADDRESS');
            $w_email = env('W_EMAIL');
            $gst = Gst::first();
        
            $data = [
                'invoice' => $invoice,
                'currency_code' => $currency_code,
                'invoice_add' => $invoice_add,
                'w_email' => $w_email,
                'gst' => $gst,
            ];
        
            $pdf = Pdf::loadView('user.download2', $data);
        
            $pdf->setPaper('A4', 'landscape');
            $pdf->setOptions([
                'defaultFont' => 'DejaVu Sans', // Fixes font_family error
                'isHtml5ParserEnabled' => true,
                'isRemoteEnabled' => true,
            ]);
        
            return $pdf->download('invoice2' . $invoice->id . '.pdf');
        }

    

}